/*            - iotn22.h -

   This file #defines the internal register addresses for ATtiny22L.

   History:
   31-Jan-02:Chris Morse:Converted to use REGISTER_VAR macros - see io-avr.h
     ** UNTESTED! **
*/

#ifndef __IOTN22
#define __IOTN22 1


/*==========================*/
/* Predefined SFR Addresses */
/*==========================*/

/* Input Pins, Port B */
#define PINB      REGISTER_VAR(0x16)

/* Data Direction Register, Port B */
#define DDRB      REGISTER_VAR(0x17)

/* Data Register, Port B */
#define PORTB     REGISTER_VAR(0x18)

/* EEPROM Control Register */
#define EECR      REGISTER_VAR(0x1C)

/* EEPROM Data Register */
#define EEDR      REGISTER_VAR(0x1D)

/* EEPROM Address Register Low */
#define EEARL     REGISTER_VAR(0x1E)

/* Watchdog Timer Control Register */
#define WDTCR     REGISTER_VAR(0x21)

/* Timer/Counter 0 */
#define TCNT0     REGISTER_VAR(0x32)

/* Timer/Counter 0 Control Register */
#define TCCR0     REGISTER_VAR(0x33)

/* MCU Status Register */
#define MCUSR     REGISTER_VAR(0x34)

/* MCU general Control Register */
#define MCUCR     REGISTER_VAR(0x35)

/* Timer/Counter Interrupt Flag register */
#define TIFR      REGISTER_VAR(0x38)

/* Timer/Counter Interrupt MaSK register */
#define TIMSK     REGISTER_VAR(0x39)

/* General Interrupt Flag register */
#define GIFR      REGISTER_VAR(0x3A)

/* General Interrupt MaSK register */
#define GIMSK     REGISTER_VAR(0x3B)

/* Stack Pointer */
#define SPL    REGISTER_VAR(0x3D)

/* Status REGister */
#define SREG      REGISTER_VAR(0x3F)


/*==============================*/
/* Interrupt Vector Definitions */
/*==============================*/

/* NB! vectors are specified as byte addresses */

#define SIG_INTERRUPT0     _vector_1
#define SIG_OVERFLOW0      _vector_2

#define END_VECTOR      (2)
#define INT_VECT_SIZE (0x06)

/*
   The Register Bit names are represented by their bit number (0-7).
 */

/* General Interrupt MaSK register */
#define    INT0    6
#define    INTF0   6

/* General Interrupt Flag Register */
#define    TOIE0   1
#define    TOV0    1

/* MCU general Control Register */
#define    SE      5
#define    SM      4
#define    ISC01   1
#define    ISC00   0

/* Timer/Counter 0 Control Register */
#define    CS02    2
#define    CS01    1
#define    CS00    0

/* Watchdog Timer Control Register */
#define    WDTOE   4
#define    WDE     3
#define    WDP2    2
#define    WDP1    1
#define    WDP0    0

/* EEPROM Control Register */
#define    EEMWE   2
#define    EEWE    1
#define    EERE    0

/*
   PB2 = SCK/T0
   PB1 = MISO/INT0
   PB0 = MOSI
 */

/* Data Register, Port B */
#define    PB4     4
#define    PB3     3
#define    PB2     2
#define    PB1     1
#define    PB0     0

/* Data Direction Register, Port B */
#define    DDB4    4
#define    DDB3    3
#define    DDB2    2
#define    DDB1    1
#define    DDB0    0

/* Input Pins, Port B */
#define    PINB4   4
#define    PINB3   3
#define    PINB2   2
#define    PINB1   1
#define    PINB0   0

/* Pointer definition   */
#define    XL     r26
#define    XH     r27
#define    YL     r28
#define    YH     r29
#define    ZL     r30
#define    ZH     r31

/* Constants */
#define    RAMEND    REGISTER_VAR(0xDF)
#define    XRAMEND      REGISTER_VAR(0xDF)
#define    E2END     REGISTER_VAR(0x7F)
#define    FLASHEND  0x07FF

#endif

