/*
   iotn11.h - internal register definitions for ATtiny10/11

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   Based on preliminary Atmel datasheet Rev. 1006B-10/99.
   ATtiny10 is a QuickFlash(tm) OTP version of ATtiny11.
 
   History:
   31-Jan-02:Chris Morse:Converted to use REGISTER_VAR macros - see io-avr.h
     ** UNTESTED! **
*/

#ifndef __IOTN11
#define __IOTN11 1

#ifndef __ASSEMBLER__
#  warning "MCU not supported by the C compiler"
#endif

/* I/O space addresses */

/* 0x00..0x07 reserved */

/* Analog Comparator Control and Status Register */
#define ACSR		REGISTER_VAR(0x08)

/* 0x09..0x15 reserved */

/* Input Pins, Port B */
#define PINB		REGISTER_VAR(0x16)

/* Data Direction Register, Port B */
#define DDRB		REGISTER_VAR(0x17)

/* Data Register, Port B */
#define PORTB		REGISTER_VAR(0x18)

/* 0x19..0x20 reserved */

/* Watchdog Timer Control Register */
#define WDTCR		REGISTER_VAR(0x21)

/* 0x22..0x31 reserved */

/* Timer/Counter0 (8-bit) */
#define TCNT0		REGISTER_VAR(0x32)

/* Timer/Counter0 Control Register */
#define TCCR0		REGISTER_VAR(0x33)

/* MCU general Status Register */
#define MCUSR		REGISTER_VAR(0x34)

/* MCU general Control Register */
#define MCUCR		REGISTER_VAR(0x35)

/* 0x36..0x37 reserved */

/* Timer/Counter Interrupt Flag Register */
#define TIFR		REGISTER_VAR(0x38)

/* Timer/Counter Interrupt MaSK Register */
#define TIMSK		REGISTER_VAR(0x39)

/* General Interrupt Flag Register */
#define GIFR		REGISTER_VAR(0x3A)

/* General Interrupt MaSK register */
#define GIMSK		REGISTER_VAR(0x3B)

/* 0x3C..0x3E reserved */

/* Status REGister */
#define SREG		REGISTER_VAR(0x3F)

/* Interrupt vectors (byte addresses) */

#define SIG_INTERRUPT0		_vector_1
#define SIG_PIN			_vector_2
#define SIG_OVERFLOW0		_vector_3
#define SIG_COMPARATOR		_vector_4

#define END_VECTOR		(5)
#define INT_VECT_SIZE (0x0a)

/* Bit numbers */

/* GIMSK */
#define INT0	6
#define PCIE	5

/* GIFR */
#define INTF0	6
#define PCIF	5

/* TIMSK */
#define TOIE0	1

/* TIFR */
#define TOV0	1

/* MCUCR */
#define SE	5
#define SM	4
#define ISC01	1
#define ISC00	0

/* TCCR0 */
#define CS02	2
#define CS01	1
#define CS00	0

/* WDTCR */
#define WDTOE	4
#define WDE	3
#define WDP2	2
#define WDP1	1
#define WDP0	0

/*
   PB5 = RESET#
   PB4 = XTAL2
   PB3 = XTAL1
   PB2 = T0
   PB1 = INT0 / AIN1
   PB0 = AIN0
 */

/* PORTB */
#define PB4	4
#define PB3	3
#define PB2	2
#define PB1	1
#define PB0	0

/* DDRB */
#define DDB4	4
#define DDB3	3
#define DDB2	2
#define DDB1	1
#define DDB0	0

/* PINB */
#define PINB5	5
#define PINB4	4
#define PINB3	3
#define PINB2	2
#define PINB1	1
#define PINB0	0

/* ACSR */
#define ACD	7
#define ACO	5
#define ACI	4
#define ACIE	3
#define ACIS1	1
#define ACIS0	0

#define ZL r30
#define ZH r31

/* Last memory addresses */
#define RAMEND		REGISTER_VAR(0x1F)
#define XRAMEND		0x0
#define E2END		0x0
#define FLASHEND	0x3FF

#endif  /* __IOTN11 */
