/*
   iom161.h - internal register definitions for ATmega161

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   Based on advance information Atmel datasheet Rev. 1228A-08/99.

   History:
   31-Jan-02:Chris Morse:Converted to use REGISTER_VAR macros - see io-avr.h
     ** UNTESTED! **
*/

#ifndef __IOM161
#define __IOM161 1

#define AVR_MEGA 1
#define AVR_ENHANCED 1

/* I/O space addresses */

/* UART1 Baud Rate Register */
#define UBRR1     REGISTER_VAR(0x00)

/* UART1 Control and Status Registers */
#define UCSR1B    REGISTER_VAR(0x01)
#define UCSR1A    REGISTER_VAR(0x02)

/* UART1 I/O Data Register */
#define UDR1      REGISTER_VAR(0x03)

/* 0x04 reserved */

/* Input Pins, Port E */
#define PINE      REGISTER_VAR(0x05)

/* Data Direction Register, Port E */
#define DDRE      REGISTER_VAR(0x06)

/* Data Register, Port E */
#define PORTE     REGISTER_VAR(0x07)

/* Analog Comparator Control and Status Register */
#define ACSR      REGISTER_VAR(0x08)

/* UART0 Baud Rate Register */
#define UBRR0     REGISTER_VAR(0x09)

/* UART0 Control and Status Registers */
#define UCSR0B    REGISTER_VAR(0x0A)
#define UCSR0A    REGISTER_VAR(0x0B)

/* UART0 I/O Data Register */
#define UDR0      REGISTER_VAR(0x0C)

/* SPI Control Register */
#define SPCR      REGISTER_VAR(0x0D)

/* SPI Status Register */
#define SPSR      REGISTER_VAR(0x0E)

/* SPI I/O Data Register */
#define SPDR      REGISTER_VAR(0x0F)

/* Input Pins, Port D */
#define PIND      REGISTER_VAR(0x10)

/* Data Direction Register, Port D */
#define DDRD      REGISTER_VAR(0x11)

/* Data Register, Port D */
#define PORTD     REGISTER_VAR(0x12)

/* Input Pins, Port C */
#define PINC      REGISTER_VAR(0x13)

/* Data Direction Register, Port C */
#define DDRC      REGISTER_VAR(0x14)

/* Data Register, Port C */
#define PORTC     REGISTER_VAR(0x15)

/* Input Pins, Port B */
#define PINB      REGISTER_VAR(0x16)

/* Data Direction Register, Port B */
#define DDRB      REGISTER_VAR(0x17)

/* Data Register, Port B */
#define PORTB     REGISTER_VAR(0x18)

/* Input Pins, Port A */
#define PINA      REGISTER_VAR(0x19)

/* Data Direction Register, Port A */
#define DDRA      REGISTER_VAR(0x1A)

/* Data Register, Port A */
#define PORTA     REGISTER_VAR(0x1B)

/* EEPROM Control Register */
#define EECR      REGISTER_VAR(0x1C)

/* EEPROM Data Register */
#define EEDR      REGISTER_VAR(0x1D)

/* EEPROM Address Register */
#define EEAR      WREGISTER_VAR(0x1E)
#define EEARL     REGISTER_VAR(0x1E)
#define EEARH     REGISTER_VAR(0x1F)

/* UART Baud Register HIgh */
#define UBRRH     REGISTER_VAR(0x20)

/* Watchdog Timer Control Register */
#define WDTCR     REGISTER_VAR(0x21)

/* Timer/Counter2 Output Compare Register */
#define OCR2      REGISTER_VAR(0x22)

/* Timer/Counter2 (8-bit) */
#define TCNT2     REGISTER_VAR(0x23)

/* Timer/Counter1 Input Capture Register */
#define ICR1      WREGISTER_VAR(0x24)
#define ICR1L     REGISTER_VAR(0x24)
#define ICR1H     REGISTER_VAR(0x25)

/* Asynchronous mode StatuS Register */
#define ASSR      REGISTER_VAR(0x26)

/* Timer/Counter2 Control Register */
#define TCCR2     REGISTER_VAR(0x27)

/* Timer/Counter1 Output Compare RegisterB */
#define OCR1B     WREGISTER_VAR(0x28)
#define OCR1BL    REGISTER_VAR(0x28)
#define OCR1BH    REGISTER_VAR(0x29)

/* Timer/Counter1 Output Compare RegisterA */
#define OCR1A     WREGISTER_VAR(0x2A)
#define OCR1AL    REGISTER_VAR(0x2A)
#define OCR1AH    REGISTER_VAR(0x2B)

/* Timer/Counter1 */
#define TCNT1     WREGISTER_VAR(0x2C)
#define TCNT1L    REGISTER_VAR(0x2C)
#define TCNT1H    REGISTER_VAR(0x2D)

/* Timer/Counter1 Control Register B */
#define TCCR1B    REGISTER_VAR(0x2E)

/* Timer/Counter1 Control Register A */
#define TCCR1A    REGISTER_VAR(0x2F)

/* Special Function IO Register */
#define SFIOR     REGISTER_VAR(0x30)

/* Timer/Counter0 Output Compare Register */
#define OCR0      REGISTER_VAR(0x31)

/* Timer/Counter0 (8-bit) */
#define TCNT0     REGISTER_VAR(0x32)

/* Timer/Counter0 Control Register */
#define TCCR0     REGISTER_VAR(0x33)

/* MCU general Status Register */
#define MCUSR     REGISTER_VAR(0x34)

/* MCU general Control Register */
#define MCUCR     REGISTER_VAR(0x35)

/* Extended MCU general Control Register */
#define EMCUCR    REGISTER_VAR(0x36)

/* Store Program Memory Control Register */
#define SPMCR     REGISTER_VAR(0x37)

/* Timer/Counter Interrupt Flag Register */
#define TIFR      REGISTER_VAR(0x38)

/* Timer/Counter Interrupt MaSK Register */
#define TIMSK     REGISTER_VAR(0x39)

/* General Interrupt Flag Register */
#define GIFR      REGISTER_VAR(0x3A)

/* General Interrupt MaSK register */
#define GIMSK     REGISTER_VAR(0x3B)

/* 0x3C reserved */

/* Stack Pointer */
#define SP        WREGISTER_VAR(0x3D)
#define SPL       REGISTER_VAR(0x3D)
#define SPH       REGISTER_VAR(0x3E)

/* Status REGister */
#define SREG      REGISTER_VAR(0x3F)

/* Interrupt vectors (byte addresses) */

#define SIG_INTERRUPT0     _vector_1
#define SIG_INTERRUPT1     _vector_2
#define SIG_INTERRUPT2     _vector_3
#define SIG_OUTPUT_COMPARE2   _vector_4
#define SIG_OVERFLOW2      _vector_5
#define SIG_INPUT_CAPTURE1 _vector_6
#define SIG_OUTPUT_COMPARE1A  _vector_7
#define SIG_OUTPUT_COMPARE1B  _vector_8
#define SIG_OVERFLOW1      _vector_9
#define SIG_OUTPUT_COMPARE0   _vector_10
#define SIG_OVERFLOW0      _vector_11
#define SIG_SPI         _vector_12
#define SIG_UART0_RECV     _vector_13
#define SIG_UART1_RECV     _vector_14
#define SIG_UART0_DATA     _vector_15
#define SIG_UART1_DATA     _vector_16
#define SIG_UART0_TRANS    _vector_17
#define SIG_UART1_TRANS    _vector_18
#define SIG_EEPROM_READY   _vector_19
#define SIG_COMPARATOR     _vector_20

#define END_VECTOR      (20)
#define INT_VECT_SIZE (0x54)

/* Bit numbers */

/* GIMSK */
#define INT1   7
#define INT0   6
#define INT2   5

/* GIFR */
#define INTF1  7
#define INTF0  6
#define INTF2  5

/* TIMSK */
#define TOIE1  7
#define OCIE1A 6
#define OCIE1B 5
#define TOIE2  4
#define TICIE1 3
#define OCIE2  2
#define TOIE0  1
#define OCIE0  0

/* TIFR */
#define TOV1   7
#define  OCF1A 6
#define  OCF1B 5
#define TOV2   4
#define ICF1   3
#define OCF2   2
#define TOV0   1
#define OCF0   0

/* MCUCR */
#define SRE 7
#define SRW10  6
#define SE  5
#define SM1 4
#define ISC11  3
#define ISC10  2
#define ISC01  1
#define ISC00  0

/* EMCUCR */
#define SM0 7
#define SRL2   6
#define SRL1   5
#define SRL0   4
#define SRW01  3
#define SRW00  2
#define SRW11  1
#define ISC2   0

/* SFIOR */
#define PSR2   1
#define PSR10  0

/* TCCR0 */
#define FOC0   7
#define PWM0   6
#define COM01  5
#define COM00  4
#define CTC0   3
#define CS02   2
#define CS01   1
#define CS00   0

/* TCCR2 */
#define FOC2   7
#define PWM2   6
#define COM21  5
#define COM20  4
#define CTC2   3
#define CS22   2
#define CS21   1
#define CS20   0

/* ASSR */
#define AS2 3
#define TCN2UB 2
#define OCR2UB 1
#define TCR2UB 0

/* TCCR1A */
#define COM1A1 7
#define COM1A0 6
#define COM1B1 5
#define COM1B0 4
#define FOC1A  3
#define FOC1B  2
#define PWM11  1
#define PWM10  0

/* TCCR1B */
#define ICNC1  7
#define ICES1  6
#define CTC1   3
#define CS12   2
#define CS11   1
#define CS10   0

/* WDTCR */
#define WDTOE  4
#define WDE 3
#define WDP2   2
#define WDP1   1
#define WDP0   0

/* EECR */
#define EERIE  3
#define EEMWE  2
#define EEWE   1
#define EERE   0

/* PORTA */
#define PA7 7
#define PA6 6
#define PA5 5
#define PA4 4
#define PA3 3
#define PA2 2
#define PA1 1
#define PA0 0

/* DDRA */
#define DDA7   7
#define DDA6   6
#define DDA5   5
#define DDA4   4
#define DDA3   3
#define DDA2   2
#define DDA1   1
#define DDA0   0

/* PINA */
#define PINA7  7
#define PINA6  6
#define PINA5  5
#define PINA4  4
#define PINA3  3
#define PINA2  2
#define PINA1  1
#define PINA0  0

/*
   PB7 = SCK
   PB6 = MISO
   PB5 = MOSI
   PB4 = SS#
   PB3 = TXD1 / AIN1
   PB2 = RXD1 / AIN0
   PB1 = OC2 / T1
   PB0 = OC0 / T0
 */

/* PORTB */
#define PB7 7
#define PB6 6
#define PB5 5
#define PB4 4
#define PB3 3
#define PB2 2
#define PB1 1
#define PB0 0

/* DDRB */
#define DDB7   7
#define DDB6   6
#define DDB5   5
#define DDB4   4
#define DDB3   3
#define DDB2   2
#define DDB1   1
#define DDB0   0

/* PINB */
#define PINB7  7
#define PINB6  6
#define PINB5  5
#define PINB4  4
#define PINB3  3
#define PINB2  2
#define PINB1  1
#define PINB0  0

/* PORTC */
#define PC7  7
#define PC6  6
#define PC5  5
#define PC4  4
#define PC3  3
#define PC2  2
#define PC1  1
#define PC0  0

/* DDRC */
#define DDC7   7
#define DDC6   6
#define DDC5   5
#define DDC4   4
#define DDC3   3
#define DDC2   2
#define DDC1   1
#define DDC0   0

/* PINC */
#define PINC7  7
#define PINC6  6
#define PINC5  5
#define PINC4  4
#define PINC3  3
#define PINC2  2
#define PINC1  1
#define PINC0  0

/*
   PD7 = RD#
   PD6 = WR#
   PD5 = TOSC2 / OC1A
   PD4 = TOSC1
   PD3 = INT1
   PD2 = INT0
   PD1 = TXD0
   PD0 = RXD0
 */

/* PORTD */
#define PD7  7
#define PD6  6
#define PD5  5
#define PD4  4
#define PD3  3
#define PD2  2
#define PD1  1
#define PD0  0

/* DDRD */
#define DDD7   7
#define DDD6   6
#define DDD5   5
#define DDD4   4
#define DDD3   3
#define DDD2   2
#define DDD1   1
#define DDD0   0

/* PIND */
#define PIND7  7
#define PIND6  6
#define PIND5  5
#define PIND4  4
#define PIND3  3
#define PIND2  2
#define PIND1  1
#define PIND0  0

/*
   PE2 = ALE
   PE1 = OC1B
   PE0 = ICP / INT2
 */

/* PORTE */
#define PE2 2
#define PE1 1
#define PE0 0

/* DDRE */
#define DDE2   2
#define DDE1   1
#define DDE0   0

/* PINE */
#define PINE2  2
#define PINE1  1
#define PINE0  0

/* SPSR */
#define SPIF   7
#define WCOL   6
#define SPI2X  0

/* SPCR */
#define SPIE   7
#define SPE 6
#define DORD   5
#define MSTR   4
#define CPOL   3
#define CPHA   2
#define SPR1   1
#define SPR0   0

/* UCSR0A */
#define RXC0   7
#define TXC0   6
#define UDRE0  5
#define FE0 4
#define OVR0   3
#define U2X0   1
#define MPCM0  0

/* UCSR1A */
#define RXC1   7
#define TXC1   6
#define UDRE1  5
#define FE1 4
#define OVR1   3
#define U2X1   1
#define MPCM1  0

/* UCSR0B */
#define RXCIE0 7
#define TXCIE0 6
#define UDRIE0 5
#define RXEN0  4
#define  TXEN0 3
#define CHR90  2
#define RXB80  1
#define TXB80  0

/* UCSR1B */
#define RXCIE1 7
#define TXCIE1 6
#define UDRIE1 5
#define RXEN1  4
#define  TXEN1 3
#define CHR91  2
#define RXB81  1
#define TXB81  0

/* ACSR */
#define ACD 7
#define AINBG  6
#define ACO 5
#define ACI 4
#define ACIE   3
#define ACIC   2
#define ACIS1  1
#define ACIS0  0

/* Pointer registers (same for all AVR devices so far) */
#define XL r26
#define XH r27
#define YL r28
#define YH r29
#define ZL r30
#define ZH r31

/* Last memory addresses */
#define RAMEND    0x45F
#define XRAMEND      0xFFFF
#define E2END     0x1FF
#define FLASHEND  0x3FFF

#endif  /* __IOM161 */
