/*
   ioat94k.h - internal register definitions for AT94K series FPSLIC(tm)

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   Based on advance information Atmel datasheet Rev. 1138B-12/99.

   History:
   31-Jan-02:Chris Morse:Converted to use REGISTER_VAR macros - see io-avr.h
     ** UNTESTED! **
*/

#ifndef __IOAT94K
#define __IOAT94K 1

#define AVR_MEGA 1
#define AVR_ENHANCED 1

/* I/O space addresses */

/* UART1 Baud Rate Register */
#define UBRR1     REGISTER_VAR(0x00)

/* UART1 Control and Status Registers */
#define USCR1B    REGISTER_VAR(0x01)
#define USCR1A    REGISTER_VAR(0x02)

/* UART1 I/O Data Register */
#define UDR1      REGISTER_VAR(0x03)

/* 0x04 reserved */

/* Input Pins, Port E */
#define PINE      REGISTER_VAR(0x05)

/* Data Direction Register, Port E */
#define DDRE      REGISTER_VAR(0x06)

/* Data Register, Port E */
#define PORTE     REGISTER_VAR(0x07)

/* 0x08 reserved */

/* UART0 Baud Rate Register */
#define UBRR0     REGISTER_VAR(0x09)

/* UART0 Control and Status Registers */
#define USCR0B    REGISTER_VAR(0x0A)
#define USCR0A    REGISTER_VAR(0x0B)

/* UART0 I/O Data Register */
#define UDR0      REGISTER_VAR(0x0C)

/* 0x0D..0x0F reserved */

/* Input Pins, Port D */
#define PIND      REGISTER_VAR(0x10)

/* Data Direction Register, Port D */
#define DDRD      REGISTER_VAR(0x11)

/* Data Register, Port D */
#define PORTD     REGISTER_VAR(0x12)

/* FPGA I/O Select Control Register */
#define FISCR     REGISTER_VAR(0x13)

/* FPGA I/O Select Registers A, B, C, D */
#define FISUA     REGISTER_VAR(0x14)
#define FISUB     REGISTER_VAR(0x15)
#define FISUC     REGISTER_VAR(0x16)
#define FISUD     REGISTER_VAR(0x17)

/* FPGA Cache Logic(R) registers (top secret, under NDA) */
#define FPGAX     REGISTER_VAR(0x18)
#define FPGAY     REGISTER_VAR(0x19)
#define FPGAZ     REGISTER_VAR(0x1A)
#define FPGAD     REGISTER_VAR(0x1B)

/* TWI stands for "Two Wire Interface" or "TWI Was I2C(tm)" */

/* 2-wire Serial Bit Rate Register */
#define TWBR      REGISTER_VAR(0x1C)

/* 2-wire Serial Status Register */
#define TWSR      REGISTER_VAR(0x1D)

/* 2-wire Serial (Slave) Address Register */
#define TWAR      REGISTER_VAR(0x1E)

/* 2-wire Serial Data Register */
#define TWDR      REGISTER_VAR(0x1F)

/* UART Baud Register High */
#define UBRRH     REGISTER_VAR(0x20)

/* Watchdog Timer Control Register */
#define WDTCR     REGISTER_VAR(0x21)

/* Timer/Counter2 Output Compare Register */
#define OCR2      REGISTER_VAR(0x22)

/* Timer/Counter2 (8-bit) */
#define TCNT2     REGISTER_VAR(0x23)

/* Timer/Counter1 Input Capture Register */
#define ICR1      WREGISTER_VAR(0x24)
#define ICR1L     REGISTER_VAR(0x24)
#define ICR1H     REGISTER_VAR(0x25)

/* Asynchronous mode StatuS Register */
#define ASSR      REGISTER_VAR(0x26)

/* Timer/Counter2 Control Register */
#define TCCR2     REGISTER_VAR(0x27)

/* Timer/Counter1 Output Compare RegisterB */
#define OCR1B     WREGISTER_VAR(0x28)
#define OCR1BL    REGISTER_VAR(0x28)
#define OCR1BH    REGISTER_VAR(0x29)

/* Timer/Counter1 Output Compare RegisterA */
#define OCR1A     WREGISTER_VAR(0x2A)
#define OCR1AL    REGISTER_VAR(0x2A)
#define OCR1AH    REGISTER_VAR(0x2B)

/* Timer/Counter1 */
#define TCNT1     WREGISTER_VAR(0x2C)
#define TCNT1L    REGISTER_VAR(0x2C)
#define TCNT1H    REGISTER_VAR(0x2D)

/* Timer/Counter1 Control Register B */
#define TCCR1B    REGISTER_VAR(0x2E)

/* Timer/Counter1 Control Register A */
#define TCCR1A    REGISTER_VAR(0x2F)

/* Special Function IO Register */
#define SFIOR     REGISTER_VAR(0x30)

/* Timer/Counter0 Output Compare Register */
#define OCR0      REGISTER_VAR(0x31)

/* Timer/Counter0 (8-bit) */
#define TCNT0     REGISTER_VAR(0x32)

/* Timer/Counter0 Control Register */
#define TCCR0     REGISTER_VAR(0x33)

/* 0x34 reserved */

/* MCU Control/Status Register */
#define MCUR      REGISTER_VAR(0x35)

/* 2-wire Serial Control Register */
#define TWCR      REGISTER_VAR(0x36)

/* 0x37 reserved */

/* Timer/Counter Interrupt Flag Register */
#define TIFR      REGISTER_VAR(0x38)

/* Timer/Counter Interrupt MaSK Register */
#define TIMSK     REGISTER_VAR(0x39)

/* Software Control Register */
#define SFTCR     REGISTER_VAR(0x3A)

/* External Interrupt Mask/Flag Register */
#define EIMF      REGISTER_VAR(0x3B)

/* 0x3C reserved */

/* Stack Pointer */
#define SP        WREGISTER_VAR(0x3D)
#define SPL       REGISTER_VAR(0x3D)
#define SPH       REGISTER_VAR(0x3E)

/* Status REGister */
#define SREG      REGISTER_VAR(0x3F)

/* Interrupt vectors (byte addresses) */


#define SIG_INTERRUPT0		_vector_1
#define SIG_FPGA_INTERRUPT0	_vector_2
#define SIG_INTERRUPT1		_vector_3
#define SIG_FPGA_INTERRUPT1	_vector_4
#define SIG_INTERRUPT2		_vector_5
#define SIG_FPGA_INTERRUPT2	_vector_6
#define SIG_INTERRUPT3		_vector_7
#define SIG_FPGA_INTERRUPT3	_vector_8
#define SIG_OUTPUT_COMPARE2	_vector_9
#define SIG_OVERFLOW2		_vector_10
#define SIG_INPUT_CAPTURE1	_vector_11
#define SIG_OUTPUT_COMPARE1A	_vector_12
#define SIG_OUTPUT_COMPARE1B	_vector_13
#define SIG_OVERFLOW1		_vector_14
#define SIG_OUTPUT_COMPARE0	_vector_15
#define SIG_OVERFLOW0		_vector_16
#define SIG_FPGA_INTERRUPT4	_vector_17
#define SIG_FPGA_INTERRUPT5	_vector_18
#define SIG_FPGA_INTERRUPT6	_vector_19
#define SIG_FPGA_INTERRUPT7	_vector_20
#define SIG_UART0_RECV		_vector_21
#define SIG_UART0_DATA		_vector_22
#define SIG_UART0_TRANS		_vector_23
#define SIG_FPGA_INTERRUPT8	_vector_24
#define SIG_FPGA_INTERRUPT9	_vector_25
#define SIG_FPGA_INTERRUPT10	_vector_26
#define SIG_FPGA_INTERRUPT11	_vector_27
#define SIG_UART1_RECV		_vector_28
#define SIG_UART1_DATA		_vector_29
#define SIG_UART1_TRANS		_vector_30
#define SIG_FPGA_INTERRUPT11	_vector_31
#define SIG_FPGA_INTERRUPT12	_vector_32
#define SIG_FPGA_INTERRUPT13	_vector_33
#define SIG_FPGA_INTERRUPT14	_vector_34
#define SIG_2WIRE_SERIAL	_vector_35

#define END_VECTOR		(35)
#define INT_VECT_SIZE (0x90)

/* Bit numbers - XXX not here yet */

/* Pointer registers (same for all AVR devices so far) */
#define XL r26
#define XH r27
#define YL r28
#define YH r29
#define ZL r30
#define ZH r31

/*
   Last memory addresses - depending on configuration, it is possible
   to have 20K-32K of program memory and 4K-16K of data memory
   (all in the same 36K total of SRAM, loaded from external EEPROM).
 */

#ifndef RAMEND
#define RAMEND 0x0FFF
#endif

#define E2END 0

#ifndef FLASHEND
#define FLASHEND 0x7FFF
#endif

#endif  /* __IOAT94K */
