/*            - io8535.h -

   This file #defines the internal register addresses for AT90S8535.

   History:
   31-Jan-02:Chris Morse:Converted to use REGISTER_VAR macros - see io-avr.h
     ** UNTESTED! **
*/

#ifndef __IO8535
#define __IO8535 1


/*==========================*/
/* Predefined SFR Addresses */
/*==========================*/

/* ADC Data register */
#define ADC       WREGISTER_VAR(0x04)
#define ADCL      REGISTER_VAR(0x04)
#define ADCH      REGISTER_VAR(0x05)

/* ADC Control and Status Register */
#define ADCSR     REGISTER_VAR(0x06)

/* ADC MUX */
#define ADMUX     REGISTER_VAR(0x07)

/* Analog Comparator Control and Status Register */
#define ACSR      REGISTER_VAR(0x08)

/* UART Baud Rate Register */
#define UBRR      REGISTER_VAR(0x09)

/* UART Control Register */
#define UCR       REGISTER_VAR(0x0A)

/* UART Status Register */
#define USR       REGISTER_VAR(0x0B)

/* UART I/O Data Register */
#define UDR       REGISTER_VAR(0x0C)

/* SPI Control Register */
#define SPCR      REGISTER_VAR(0x0D)

/* SPI Status Register */
#define SPSR      REGISTER_VAR(0x0E)

/* SPI I/O Data Register */
#define SPDR      REGISTER_VAR(0x0F)

/* Input Pins, Port D */
#define PIND      REGISTER_VAR(0x10)

/* Data Direction Register, Port D */
#define DDRD      REGISTER_VAR(0x11)

/* Data Register, Port D */
#define PORTD     REGISTER_VAR(0x12)

/* Input Pins, Port C */
#define PINC      REGISTER_VAR(0x13)

/* Data Direction Register, Port C */
#define DDRC      REGISTER_VAR(0x14)

/* Data Register, Port C */
#define PORTC     REGISTER_VAR(0x15)

/* Input Pins, Port B */
#define PINB      REGISTER_VAR(0x16)

/* Data Direction Register, Port B */
#define DDRB      REGISTER_VAR(0x17)

/* Data Register, Port B */
#define PORTB     REGISTER_VAR(0x18)

/* Input Pins, Port A */
#define PINA      REGISTER_VAR(0x19)

/* Data Direction Register, Port A */
#define DDRA      REGISTER_VAR(0x1A)

/* Data Register, Port A */
#define PORTA     REGISTER_VAR(0x1B)

/* EEPROM Control Register */
#define EECR      REGISTER_VAR(0x1C)

/* EEPROM Data Register */
#define EEDR      REGISTER_VAR(0x1D)

/* EEPROM Address Register */
#define EEAR      WREGISTER_VAR(0x1E)
#define EEARL     REGISTER_VAR(0x1E)
#define EEARH     REGISTER_VAR(0x1F)

/* Watchdog Timer Control Register */
#define WDTCR     REGISTER_VAR(0x21)

/* Asynchronous mode Status Register */
#define ASSR      REGISTER_VAR(0x22)

/* Timer/Counter2 Output Compare Register */
#define OCR2      REGISTER_VAR(0x23)

/* Timer/Counter 2 */
#define TCNT2     REGISTER_VAR(0x24)

/* Timer/Counter 2 Control Register */
#define TCCR2     REGISTER_VAR(0x25)

/* T/C 1 Input Capture Register */
#define ICR1      WREGISTER_VAR(0x26)
#define ICR1L     REGISTER_VAR(0x26)
#define ICR1H     REGISTER_VAR(0x27)

/* Timer/Counter1 Output Compare Register B */
#define OCR1B     WREGISTER_VAR(0x28)
#define OCR1BL    REGISTER_VAR(0x28)
#define OCR1BH    REGISTER_VAR(0x29)

/* Timer/Counter1 Output Compare Register A */
#define OCR1A     WREGISTER_VAR(0x2A)
#define OCR1AL    REGISTER_VAR(0x2A)
#define OCR1AH    REGISTER_VAR(0x2B)

/* Timer/Counter 1 */
#define TCNT1     WREGISTER_VAR(0x2C)
#define TCNT1L    REGISTER_VAR(0x2C)
#define TCNT1H    REGISTER_VAR(0x2D)

/* Timer/Counter 1 Control and Status Register */
#define TCCR1B    REGISTER_VAR(0x2E)

/* Timer/Counter 1 Control Register */
#define TCCR1A    REGISTER_VAR(0x2F)

/* Timer/Counter 0 */
#define TCNT0     REGISTER_VAR(0x32)

/* Timer/Counter 0 Control Register */
#define TCCR0     REGISTER_VAR(0x33)

/* MCU general Status Register */
#define MCUSR     REGISTER_VAR(0x34)

/* MCU general Control Register */
#define MCUCR     REGISTER_VAR(0x35)

/* Timer/Counter Interrupt Flag register */
#define TIFR      REGISTER_VAR(0x38)

/* Timer/Counter Interrupt MaSK register */
#define TIMSK     REGISTER_VAR(0x39)

/* General Interrupt Flag Register */
#define GIFR      REGISTER_VAR(0x3A)

/* General Interrupt MaSK register */
#define GIMSK     REGISTER_VAR(0x3B)

/* Stack Pointer */
#define SP        WREGISTER_VAR(0x3D)
#define SPL       REGISTER_VAR(0x3D)
#define SPH       REGISTER_VAR(0x3E)

/* Status REGister */
#define SREG      REGISTER_VAR(0x3F)


/*                              */
/* Interrupt Vector Definitions */
/*                              */

#define SIG_INTERRUPT0     _vector_1
#define SIG_INTERRUPT1     _vector_2
#define SIG_OUTPUT_COMPARE2   _vector_3
#define SIG_OVERFLOW2      _vector_4
#define SIG_INPUT_CAPTURE1 _vector_5
#define SIG_OUTPUT_COMPARE1A  _vector_6
#define SIG_OUTPUT_COMPARE1B  _vector_7
#define SIG_OVERFLOW1      _vector_8
#define SIG_OVERFLOW0      _vector_9
#define SIG_SPI         _vector_10
#define SIG_UART_RECV      _vector_11
#define SIG_UART_DATA      _vector_12
#define SIG_UART_TRANS     _vector_13
#define SIG_ADC         _vector_14
#define SIG_EEPROM_READY   _vector_15
#define SIG_COMPARATOR     _vector_16

#define END_VECTOR      (16)
#define INT_VECT_SIZE (0x22)

/*
   The Register Bit names are represented by their bit number (0-7).
*/

/* MCU general Status Register */
#define    EXTRF       1
#define    PORF        0

/* General Interrupt MaSK register */
#define    INT1        7
#define    INT0        6

/* General Interrupt Flag Register */
#define    INTF1       7
#define    INTF0       6

/* Timer/Counter Interrupt MaSK register */
#define    OCIE2       7
#define    TOIE2       6
#define    TICIE1      5
#define    OCIE1A      4
#define    OCIE1B      3
#define    TOIE1       2
#define    TOIE0       0

/* Timer/Counter Interrupt Flag register */
#define    OCF2         7
#define    TOV2         6
#define    ICF1         5
#define    OCF1A        4
#define    OCF1B        3
#define    TOV1         2
#define    TOV0         0

/* MCU general Control Register */
#define    SE           6
#define    SM1          5
#define    SM0          4
#define    ISC11        3
#define    ISC10        2
#define    ISC01        1
#define    ISC00        0

/* Timer/Counter 0 Control Register */
#define    CS02         2
#define    CS01         1
#define    CS00         0

/* Timer/Counter 1 Control Register */
#define    COM1A1       7
#define    COM1A0       6
#define    COM1B1       5
#define    COM1B0       4
#define    PWM11        1
#define    PWM10        0

/* Timer/Counter 1 Control and Status Register */
#define    ICNC1        7
#define    ICES1        6
#define    CTC1         3
#define    CS12         2
#define    CS11         1
#define    CS10         0

/* Timer/Counter 2 Control Register */
#define    PWM2         6
#define    COM21        5
#define    COM20        4
#define    CTC2         3
#define    CS22         2
#define    CS21         1
#define    CS20         0

/* Asynchronous mode Status Register */
#define    AS2          3
#define    TCN2UB       2
#define    OCR2UB       1
#define    TCR2UB       0

/* Watchdog Timer Control Register */
#define    WDTOE        4
#define    WDE          3
#define    WDP2         2
#define    WDP1         1
#define    WDP0         0

/* EEPROM Control Register */
#define    EERIE        3
#define    EEMWE        2
#define    EEWE         1
#define    EERE         0

/* Data Register, Port A */
#define    PA7      7
#define    PA6      6
#define    PA5      5
#define    PA4      4
#define    PA3      3
#define    PA2      2
#define    PA1      1
#define    PA0      0

/* Data Direction Register, Port A */
#define    DDA7     7
#define    DDA6     6
#define    DDA5     5
#define    DDA4     4
#define    DDA3     3
#define    DDA2     2
#define    DDA1     1
#define    DDA0     0

/* Input Pins, Port A */
#define    PINA7    7
#define    PINA6    6
#define    PINA5    5
#define    PINA4    4
#define    PINA3    3
#define    PINA2    2
#define    PINA1    1
#define    PINA0    0

/* Data Register, Port B */
#define    PB7      7
#define    PB6      6
#define    PB5      5
#define    PB4      4
#define    PB3      3
#define    PB2      2
#define    PB1      1
#define    PB0      0

/* Data Direction Register, Port B */
#define    DDB7     7
#define    DDB6     6
#define    DDB5     5
#define    DDB4     4
#define    DDB3     3
#define    DDB2     2
#define    DDB1     1
#define    DDB0     0

/* Input Pins, Port B */
#define    PINB7    7
#define    PINB6    6
#define    PINB5    5
#define    PINB4    4
#define    PINB3    3
#define    PINB2    2
#define    PINB1    1
#define    PINB0    0

/* Data Register, Port C */
#define    PC7      7
#define    PC6      6
#define    PC5      5
#define    PC4      4
#define    PC3      3
#define    PC2      2
#define    PC1      1
#define    PC0      0

/* Data Direction Register, Port C */
#define    DDC7     7
#define    DDC6     6
#define    DDC5     5
#define    DDC4     4
#define    DDC3     3
#define    DDC2     2
#define    DDC1     1
#define    DDC0     0

/* Input Pins, Port C */
#define    PINC7    7
#define    PINC6    6
#define    PINC5    5
#define    PINC4    4
#define    PINC3    3
#define    PINC2    2
#define    PINC1    1
#define    PINC0    0

/* Data Register, Port D */
#define    PD7      7
#define    PD6      6
#define    PD5      5
#define    PD4      4
#define    PD3      3
#define    PD2      2
#define    PD1      1
#define    PD0      0

/* Data Direction Register, Port D */
#define    DDD7     7
#define    DDD6     6
#define    DDD5     5
#define    DDD4     4
#define    DDD3     3
#define    DDD2     2
#define    DDD1     1
#define    DDD0     0

/* Input Pins, Port D */
#define    PIND7     7
#define    PIND6     6
#define    PIND5     5
#define    PIND4     4
#define    PIND3     3
#define    PIND2     2
#define    PIND1     1
#define    PIND0     0

/* SPI Control Register */
#define    SPIE     7
#define    SPE      6
#define    DORD     5
#define    MSTR     4
#define    CPOL     3
#define    CPHA     2
#define    SPR1     1
#define    SPR0     0

/* SPI Status Register */
#define    SPIF     7
#define    WCOL     6

/* UART Status Register */
#define    RXC      7
#define    TXC      6
#define    UDRE     5
#define    FE       4
#define    OVR      3    /*This definition differs from the databook    */
                        /*definition to avoid problems with the OR instruction */

/* UART Control Register */
#define    RXCIE    7
#define    TXCIE    6
#define    UDRIE    5
#define    RXEN     4
#define    TXEN     3
#define    CHR9     2
#define    RXB8     1
#define    TXB8     0

/* Analog Comparator Control and Status Register */
#define    ACD      7
#define    ACO      5
#define    ACI      4
#define    ACIE     3
#define    ACIC     2
#define    ACIS1    1
#define    ACIS0    0

/* ADC MUX */
#define    MUX2     2
#define    MUX1     1
#define    MUX0     0

/* ADC Control and Status Register */
#define    ADEN     7
#define    ADSC     6
#define    ADFR     5
#define    ADIF     4
#define    ADIE     3
#define    ADPS2    2
#define    ADPS1    1
#define    ADPS0    0

/* Pointer definition   */
#define    XL     r26
#define    XH     r27
#define    YL     r28
#define    YH     r29
#define    ZL     r30
#define    ZH     r31

/* Constants */
#define    RAMEND   0x25F    /*Last On-Chip SRAM location*/
#define    XRAMEND  0x25F
#define    E2END    0x1FF
#define    FLASHEND 0x1FFF

#endif
