/*
   io-avr.h

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   History:
   21-Jan-02:Chris Morse:Added macros to allow register access via assignment operator
 */

#ifndef _IO_AVR_H_
#define _IO_AVR_H_ 1

/********************************************************************
* BEGIN: Define how registers are accessed                          *
* The macros below enable registers to be accessed using the        *
* assignment operator (=) instead of the inp() outp() macros.       *
*                                                                   *
* Old code that still uses these macros can compile with            *
* _REGISTER_VAR_ADDR_MODE_ defined to specify the address-style     *
* register definitions instead of these pointer-style.              *
*                                                                   *
* New code can compile with _REGISTER_VAR_PTR_MODE_ with explicitly *
* defined to assure forward-compatibility although, pointer-style   *
* is the default setting here.                                      *
********************************************************************/
#if !defined(_IO_REG_ASSIGN_MODE_) && !defined(_IO_REG_MACRO_MODE_)
	#define _IO_REG_ASSIGN_MODE_ 
#endif

/* Macros to convert register address to pointer-style or address-style notation */
#if defined(_IO_REG_ASSIGN_MODE_)
	#define REGISTER_VAR(x)		(*(volatile uint8_t*)((x)+0x20))
	
	/* NB: The Wxxs macros are intended to provide direct access to   *
	* 16-bit registers however, it's not recommended because I don't  *
	* think avr-gcc knows to use the temp register to set them        *
	* as is specified in the Atmel datasheets.  Use with caution     */
	#define WREGISTER_VAR(x)	(*(volatile uint16_t*)((x)+0x20))
   /* The XREGISTER is for use with the ATMEGA128 extended register set that
   *  is addressed directly by RAM address, so 0x20 adder is not required */
   #define XREGISTER_VAR(x)    (*(volatile uint8_t*)((x)))
   #define XWREGISTER_VAR(x)  (*(volatile uint16_t*)((x)))
#elif defined(_IO_REG_MACRO_MODE_)
	#define REGISTER_VAR(x)		(x)
	#define WREGISTER_VAR(x)	(x)
   #define XREGISTER_VAR(x)    (x)
#endif
/********************************************/
/* END: Define how registers are accessed */
/********************************************/


#if defined (__AVR_AT94K__)
#  include <ioat94k.h>
#elif defined (__AVR_ATmega128__)
#  include <iom128.h>
#elif defined (__AVR_ATmega103__)
#  include <iom103.h>
#elif defined (__AVR_ATmega603__)
#  include <iom603.h>
#elif defined (__AVR_ATmega32__)
#  include <iom32.h>
#elif defined (__AVR_ATmega163__)
#  include <iom163.h>
#elif defined (__AVR_ATmega161__)
#  include <iom161.h>
#elif defined (__AVR_ATmega85__)
#  include <iom85.h>  /* XXX not here yet */
#elif defined (__AVR_ATmega83__)
#  include <iom83.h>
#elif defined (__AVR_AT90S8535__)
#  include <io8535.h>
#elif defined (__AVR_AT90C8534__)
#  include <io8534.h>
#elif defined (__AVR_AT90S8515__)
#  include <io8515.h>
#elif defined (__AVR_AT90S4434__)
#  include <io4434.h>
#elif defined (__AVR_AT90S4433__)
#  include <io4433.h>
#elif defined (__AVR_AT90S4414__)
#  include <io4414.h>
#elif defined (__AVR_ATtiny22__)
#  include <iotn22.h>
#elif defined (__AVR_AT90S2343__)
#  include <io2343.h>
#elif defined (__AVR_AT90S2333__)
#  include <io2333.h>
#elif defined (__AVR_AT90S2323__)
#  include <io2323.h>
#elif defined (__AVR_AT90S2313__)
#  include <io2313.h>
 /* the following only supported for assembler programs */
#elif defined (__AVR_ATtiny28__)
#  include <iotn28.h>
#elif defined (__AVR_AT90S1200__)
#  include <io1200.h>
#elif defined (__AVR_ATtiny15__)
#  include <iotn15.h>
#elif defined (__AVR_ATtiny12__)
#  include <iotn12.h>
#elif defined (__AVR_ATtiny11__)
#  include <iotn11.h>
#else
#  warning "device type not defined"
/* #  include <io8515.h> */
#endif

#endif
